﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;

namespace SWAT_Office_App
{
    public partial class Add_User_Account_Form : Form
    {
        private static Add_User_Account_Form _Add_User_Account_Instance = null;
        // Modified singleton instance
        public static Add_User_Account_Form Add_User_Account_Instance
        {
            get
            {
                _Add_User_Account_Instance = new Add_User_Account_Form();
                return _Add_User_Account_Instance;
            }
        }
        public Add_User_Account_Form()
        {
            InitializeComponent();

            resetForm();

            this.txt_Username.TextChanged += new EventHandler(txt_EmptyTxtBox);
            this.txt_Password.TextChanged += new EventHandler(txt_EmptyTxtBox);
            this.txt_Username.KeyPress += new KeyPressEventHandler(txt_Username_KeyPress);
        }
        private void resetForm()
        {
            this.btn_Add.Enabled = false;
            this.txt_Username.Text = "";
            this.txt_Password.Text = "";
            this.txt_Username.Tag = false;
            this.txt_Password.Tag = false;
            this.txt_Username.Focus();
        }
        private void txt_EmptyTxtBox(object sender, EventArgs e)
        {
            TextBox tb = (TextBox)sender;
            if (tb.Text.Length == 0)
                tb.Tag = false;
            else
                tb.Tag = true;
            ValidateBox();
        }
        private void ValidateBox()
        {
            this.btn_Add.Enabled = ((bool)(this.txt_Username.Tag) && (bool)(this.txt_Password.Tag));
        }
        private void txt_Username_KeyPress(object sender, KeyPressEventArgs e)
        {
            // Blocks symbols that cannot be used in the username field
            if ((e.KeyChar < 32 || e.KeyChar == 34 || (e.KeyChar > 41 && e.KeyChar < 45) || e.KeyChar == 47 ||
                (e.KeyChar > 57 && e.KeyChar < 65) || (e.KeyChar > 90 && e.KeyChar < 94) || e.KeyChar > 122) && e.KeyChar != 8)
                e.Handled = true;
        }
        private void btn_Cancel_Click(object sender, EventArgs e)
        {
            this.Close();
        }
        private void btn_Add_Click(object sender, EventArgs e)
        {
            if (Manage_User_Accounts.AddUser(txt_Username.Text, txt_Password.Text))
            {
                if (this.chk_Share.Checked == true)
                    if (!Manage_User_Accounts.CreateShareFolder(txt_Username.Text))
                    {
                        Debug.appendText("Error occured while creating shared folder");
                        MessageBox.Show("Error occured when creating shared folder", "Error");
                    }
                this.Close();
            }
            else
            {
                Debug.appendText("Error occured while creating new user account");
                MessageBox.Show("Error occured when creating new user account","Error");
                resetForm();
            }
        }
    }
}
